/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.StatusInfoInterface;
import com.ibm.hwmca.ui.bonsai.earth.TaskManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.table.StatusTableCellBean;
import com.ibm.psw.wcl.components.table.AbstractExtendedTableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class TreeTableModel
extends AbstractExtendedTableModel {
    private String id;
    private List colTypes;
    private List colHeaders;
    private List rows;
    private List rowIds;
    private Locale locale;

    public TreeTableModel(Locale locale) {
        this.locale = locale;
        this.colTypes = new ArrayList();
        this.colHeaders = new ArrayList();
        this.colTypes.add("empty");
        this.colHeaders.add("");
        this.rows = new ArrayList();
    }

    public TreeTableModel(BonsaiTreeNode parentNode, UISession session, Locale locale) {
        this.locale = locale;
        this.setData(parentNode, session);
    }

    public void setData(BonsaiTreeNode parentNode, UISession session) {
        this.id = parentNode.getId();
        this.colTypes = new ArrayList();
        this.colHeaders = new ArrayList();
        this.colTypes.add("empty");
        this.colHeaders.add("");
        List children = parentNode.getChildren();
        int numNodes = children.size();
        ArrayList<BonsaiTreeNode> nodes = new ArrayList<BonsaiTreeNode>(numNodes);
        BonsaiTreeNode child = null;
        boolean colsInitialized = false;
        for (int i = 0; i < numNodes; ++i) {
            child = (BonsaiTreeNode)children.get(i);
            if (!child.isShown(session)) continue;
            nodes.add(child);
            if (!colsInitialized) {
                this.colTypes = new ArrayList(child.getColumnTypes());
                this.colHeaders = new ArrayList(child.getColumnHeaders(this.locale));
                colsInitialized = true;
                continue;
            }
            for (int j = 0; j < this.colTypes.size(); ++j) {
                if (child.getColumnTypes().contains(this.colTypes.get(j))) continue;
                this.colHeaders.remove(j);
                this.colTypes.remove(j);
            }
        }
        this.rowIds = new ArrayList(nodes.size());
        this.rows = new ArrayList(nodes.size());
        BonsaiTreeNode node = null;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            node = (BonsaiTreeNode)i.next();
            this.rowIds.add(node.getId());
            this.rows.add(this.buildRow(node));
        }
    }

    public void update(UISession session) {
        int[] selectedRows = this.getSelectedModelRows();
        ArrayList selectedIds = new ArrayList(selectedRows.length);
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedIds.add(this.rowIds.get(selectedRows[i]));
        }
        this.setData(BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(this.id), session);
        Iterator i = selectedIds.iterator();
        while (i.hasNext()) {
            this.setSelectedRowById((String)i.next());
        }
    }

    public String getId() {
        return this.id;
    }

    public int getColumnCount() {
        return this.colHeaders.size();
    }

    public String getColumnName(int col) {
        return (String)this.colHeaders.get(col);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int row, int col) {
        return ((List)this.rows.get(row)).get(col);
    }

    public Vector getDataVectorMatrix() {
        Vector rowVector = new Vector(this.rows.size());
        Iterator i = this.rows.iterator();
        while (i.hasNext()) {
            rowVector.add(new Vector((List)i.next()));
        }
        return rowVector;
    }

    public Vector getColumnVectorHeaders() {
        return new Vector(this.colHeaders);
    }

    public boolean setSelectedRowById(String rowId) {
        for (int i = 0; i < this.rowIds.size(); ++i) {
            if (!this.rowIds.get(i).equals(rowId)) continue;
            this.addSelectionInterval(i, i, null);
            return true;
        }
        return false;
    }

    public List getSelectedNodeIds() {
        int[] rows = this.getSelectedModelRows();
        ArrayList selectedIds = new ArrayList(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            selectedIds.add(this.rowIds.get(rows[i]));
        }
        return selectedIds;
    }

    private List buildRow(BonsaiTreeNode node) {
        ArrayList<Serializable> row = new ArrayList<Serializable>(this.colHeaders.size());
        Map nodeValues = node.getColumnValues(this.locale);
        String column = null;
        Iterator i = this.colTypes.iterator();
        while (i.hasNext()) {
            column = (String)i.next();
            if (column.equals("Name")) {
                UIInfo uiInfo = node.getUIInfo();
                row.add(new NameTableCellBean(uiInfo.getName(this.locale), TaskManager.getTaskManager().getDefaultTaskUrl(node), uiInfo.getImageURL(), uiInfo.getImageName(), node.getId()));
                continue;
            }
            if (column.equals("Status")) {
                StatusInfoInterface statusInfo = (StatusInfoInterface)((Object)node);
                row.add(new StatusTableCellBean(statusInfo.getShortId(), statusInfo.getStatus().toString(this.locale), statusInfo.isStatusAcceptable(), statusInfo.hasAttentions(), statusInfo.getStatusTaskUrl()));
                continue;
            }
            row.add((Serializable)nodeValues.get(column));
        }
        return row;
    }
}

